<?php
require_once 'config.php';

if(!isLoggedIn()) {
    header("Location: login.php");
    exit();
}

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user_result = $stmt->get_result();
$user = $user_result->fetch_assoc();

// Get user stats
$orders_count = $conn->query("SELECT COUNT(*) as count FROM orders WHERE user_id = $user_id")->fetch_assoc()['count'];
$referrals_count = $conn->query("SELECT COUNT(*) as count FROM referrals WHERE referrer_id = $user_id AND status = 'paid'")->fetch_assoc()['count'];
$transactions_count = $conn->query("SELECT COUNT(*) as count FROM transactions WHERE user_id = $user_id")->fetch_assoc()['count'];

// Get recent transactions
$recent_transactions = $conn->query("SELECT * FROM transactions WHERE user_id = $user_id ORDER BY created_at DESC LIMIT 5");

// Get recent orders
$recent_orders = $conn->query("SELECT o.*, p.name as product_name FROM orders o 
                              JOIN products p ON o.product_id = p.id 
                              WHERE o.user_id = $user_id 
                              ORDER BY o.created_at DESC LIMIT 5");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Project Sale</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        .stat-card {
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .gradient-text {
            background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .sidebar {
            transition: all 0.3s ease;
        }
        .sidebar-link {
            transition: all 0.2s ease;
        }
        .sidebar-link:hover {
            transform: translateX(5px);
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Sidebar for Mobile -->
    <div class="md:hidden fixed inset-0 z-50" id="mobileSidebar" style="display: none;">
        <div class="fixed inset-0 bg-black bg-opacity-50" onclick="toggleSidebar()"></div>
        <div class="fixed inset-y-0 left-0 w-64 bg-white shadow-xl transform transition-transform">
            <div class="p-6">
                <div class="flex items-center justify-between mb-8">
                    <h2 class="text-xl font-bold text-gray-800">Menu</h2>
                    <button onclick="toggleSidebar()" class="text-gray-500 hover:text-gray-700">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                <?php include 'includes/sidebar.php'; ?>
            </div>
        </div>
    </div>

    <!-- Main Layout -->
    <div class="flex min-h-screen">
        <!-- Sidebar (Desktop) -->
        <div class="hidden md:block w-64 bg-white shadow-lg sidebar">
            <?php include 'includes/sidebar.php'; ?>
        </div>
        
        <!-- Main Content -->
        <div class="flex-1">
            <!-- Header -->
            <header class="bg-white shadow-sm border-b">
                <div class="px-6 py-4 flex items-center justify-between">
                    <div class="flex items-center">
                        <button onclick="toggleSidebar()" class="md:hidden text-gray-600 hover:text-gray-800 mr-4">
                            <i class="fas fa-bars text-xl"></i>
                        </button>
                        <h1 class="text-2xl font-bold gradient-text">
                            <i class="fas fa-tachometer-alt mr-2"></i> Dashboard
                        </h1>
                    </div>
                    
                    <div class="flex items-center space-x-4">
                        <div class="relative group">
                            <button class="flex items-center space-x-2 text-gray-700 hover:text-blue-600">
                                <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center text-white font-bold">
                                    <?php echo strtoupper(substr($user['username'], 0, 1)); ?>
                                </div>
                                <span class="hidden md:inline font-medium"><?php echo $user['username']; ?></span>
                                <i class="fas fa-chevron-down text-sm"></i>
                            </button>
                            <div class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-xl py-2 z-50 hidden group-hover:block">
                                <a href="profile.php" class="block px-4 py-2 text-gray-700 hover:bg-blue-50 hover:text-blue-600">
                                    <i class="fas fa-user mr-2"></i> Profile
                                </a>
                                <a href="logout.php" class="block px-4 py-2 text-gray-700 hover:bg-red-50 hover:text-red-600">
                                    <i class="fas fa-sign-out-alt mr-2"></i> Logout
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Main Content Area -->
            <main class="p-6">
                <!-- Welcome Banner -->
                <div class="bg-gradient-to-r from-blue-500 to-indigo-600 rounded-2xl p-8 text-white mb-8 animate__animated animate__fadeIn">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div>
                            <h2 class="text-3xl font-bold mb-2">
                                Welcome back, <?php echo $user['username']; ?>! 👋
                            </h2>
                            <p class="text-blue-100">
                                <?php echo $user['is_active'] ? 'Your account is active and ready to use.' : 'Activate your account to unlock all features.'; ?>
                            </p>
                        </div>
                        <div class="mt-4 md:mt-0">
                            <?php if(!$user['is_active']): ?>
                                <a href="activate.php" 
                                   class="inline-block bg-white text-blue-600 px-6 py-3 rounded-full font-bold hover:bg-blue-50 transition duration-300 transform hover:scale-105">
                                    <i class="fas fa-bolt mr-2"></i> Activate Account
                                </a>
                            <?php else: ?>
                                <a href="products.php" 
                                   class="inline-block bg-white text-blue-600 px-6 py-3 rounded-full font-bold hover:bg-blue-50 transition duration-300 transform hover:scale-105">
                                    <i class="fas fa-shopping-cart mr-2"></i> Browse Products
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Stats Cards -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                    <!-- Balance Card -->
                    <div class="stat-card bg-white rounded-xl shadow-lg p-6 animate__animated animate__fadeInUp">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-gray-500 text-sm font-medium">Current Balance</p>
                                <h3 class="text-3xl font-bold text-gray-800 mt-2">৳<?php echo number_format($user['balance'], 2); ?></h3>
                            </div>
                            <div class="w-14 h-14 bg-gradient-to-r from-green-400 to-emerald-500 rounded-full flex items-center justify-center">
                                <i class="fas fa-wallet text-white text-2xl"></i>
                            </div>
                        </div>
                        <div class="mt-6 flex space-x-3">
                            <a href="deposit.php" 
                               class="flex-1 bg-green-100 text-green-700 text-center py-2 rounded-lg font-medium hover:bg-green-200 transition duration-300">
                                <i class="fas fa-plus mr-1"></i> Deposit
                            </a>
                            <a href="withdraw.php" 
                               class="flex-1 bg-blue-100 text-blue-700 text-center py-2 rounded-lg font-medium hover:bg-blue-200 transition duration-300">
                                <i class="fas fa-minus mr-1"></i> Withdraw
                            </a>
                        </div>
                    </div>
                    
                    <!-- Account Status -->
                    <div class="stat-card bg-white rounded-xl shadow-lg p-6 animate__animated animate__fadeInUp" style="animation-delay: 0.1s">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-gray-500 text-sm font-medium">Account Status</p>
                                <h3 class="text-2xl font-bold mt-2 <?php echo $user['is_active'] ? 'text-green-600' : 'text-red-600'; ?>">
                                    <?php echo $user['is_active'] ? 'Active' : 'Inactive'; ?>
                                </h3>
                            </div>
                            <div class="w-14 h-14 rounded-full flex items-center justify-center <?php echo $user['is_active'] ? 'bg-gradient-to-r from-green-400 to-emerald-500' : 'bg-gradient-to-r from-red-400 to-pink-500'; ?>">
                                <i class="fas <?php echo $user['is_active'] ? 'fa-check-circle' : 'fa-lock'; ?> text-white text-2xl"></i>
                            </div>
                        </div>
                        <?php if(!$user['is_active']): ?>
                            <div class="mt-6">
                                <a href="activate.php" 
                                   class="block w-full bg-gradient-to-r from-yellow-400 to-orange-500 text-white text-center py-3 rounded-lg font-bold hover:opacity-90 transition duration-300">
                                    <i class="fas fa-bolt mr-2"></i> Activate Now
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Orders Card -->
                    <div class="stat-card bg-white rounded-xl shadow-lg p-6 animate__animated animate__fadeInUp" style="animation-delay: 0.2s">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-gray-500 text-sm font-medium">Total Orders</p>
                                <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $orders_count; ?></h3>
                            </div>
                            <div class="w-14 h-14 bg-gradient-to-r from-purple-400 to-pink-500 rounded-full flex items-center justify-center">
                                <i class="fas fa-shopping-bag text-white text-2xl"></i>
                            </div>
                        </div>
                        <div class="mt-6">
                            <a href="my-orders.php" 
                               class="block w-full bg-purple-100 text-purple-700 text-center py-3 rounded-lg font-medium hover:bg-purple-200 transition duration-300">
                                <i class="fas fa-eye mr-2"></i> View Orders
                            </a>
                        </div>
                    </div>
                    
                    <!-- Referrals Card -->
                    <div class="stat-card bg-white rounded-xl shadow-lg p-6 animate__animated animate__fadeInUp" style="animation-delay: 0.3s">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-gray-500 text-sm font-medium">Referrals</p>
                                <h3 class="text-3xl font-bold text-gray-800 mt-2"><?php echo $referrals_count; ?></h3>
                            </div>
                            <div class="w-14 h-14 bg-gradient-to-r from-blue-400 to-cyan-500 rounded-full flex items-center justify-center">
                                <i class="fas fa-users text-white text-2xl"></i>
                            </div>
                        </div>
                        <div class="mt-6">
                            <a href="referrals.php" 
                               class="block w-full bg-blue-100 text-blue-700 text-center py-3 rounded-lg font-medium hover:bg-blue-200 transition duration-300">
                                <i class="fas fa-share-alt mr-2"></i> View Referrals
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Two Columns Layout -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                    <!-- Recent Transactions -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInLeft">
                        <div class="bg-gradient-to-r from-blue-500 to-indigo-600 px-6 py-4">
                            <h3 class="text-xl font-bold text-white">
                                <i class="fas fa-exchange-alt mr-2"></i> Recent Transactions
                            </h3>
                        </div>
                        <div class="p-6">
                            <?php if($recent_transactions->num_rows > 0): ?>
                                <div class="space-y-4">
                                    <?php while($transaction = $recent_transactions->fetch_assoc()): ?>
                                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition duration-300">
                                            <div>
                                                <div class="flex items-center">
                                                    <?php
                                                    $icon_class = '';
                                                    $color_class = '';
                                                    switch($transaction['type']) {
                                                        case 'deposit':
                                                            $icon_class = 'fa-plus-circle';
                                                            $color_class = 'text-green-500';
                                                            break;
                                                        case 'withdrawal':
                                                            $icon_class = 'fa-minus-circle';
                                                            $color_class = 'text-red-500';
                                                            break;
                                                        case 'activation':
                                                            $icon_class = 'fa-bolt';
                                                            $color_class = 'text-yellow-500';
                                                            break;
                                                        case 'referral_bonus':
                                                            $icon_class = 'fa-user-friends';
                                                            $color_class = 'text-blue-500';
                                                            break;
                                                        default:
                                                            $icon_class = 'fa-shopping-cart';
                                                            $color_class = 'text-purple-500';
                                                    }
                                                    ?>
                                                    <i class="fas <?php echo $icon_class; ?> <?php echo $color_class; ?> text-xl mr-3"></i>
                                                    <div>
                                                        <p class="font-medium text-gray-800"><?php echo ucfirst(str_replace('_', ' ', $transaction['type'])); ?></p>
                                                        <p class="text-sm text-gray-500">
                                                            <?php echo date('M d, Y h:i A', strtotime($transaction['created_at'])); ?>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="text-right">
                                                <p class="font-bold text-lg <?php echo in_array($transaction['type'], ['deposit', 'referral_bonus']) ? 'text-green-600' : 'text-red-600'; ?>">
                                                    <?php echo in_array($transaction['type'], ['deposit', 'referral_bonus']) ? '+' : '-'; ?>৳<?php echo number_format($transaction['amount'], 2); ?>
                                                </p>
                                                <span class="inline-block px-2 py-1 text-xs rounded-full 
                                                    <?php echo $transaction['status'] == 'completed' ? 'bg-green-100 text-green-800' : 
                                                           ($transaction['status'] == 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800'); ?>">
                                                    <?php echo ucfirst($transaction['status']); ?>
                                                </span>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-8">
                                    <i class="fas fa-exchange-alt text-gray-300 text-5xl mb-4"></i>
                                    <p class="text-gray-500">No transactions yet</p>
                                </div>
                            <?php endif; ?>
                            
                            <div class="mt-6 text-center">
                                <a href="transactions.php" class="text-blue-600 hover:text-blue-800 font-medium">
                                    <i class="fas fa-list mr-1"></i> View All Transactions
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Recent Orders -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInRight">
                        <div class="bg-gradient-to-r from-purple-500 to-pink-600 px-6 py-4">
                            <h3 class="text-xl font-bold text-white">
                                <i class="fas fa-shopping-bag mr-2"></i> Recent Orders
                            </h3>
                        </div>
                        <div class="p-6">
                            <?php if($recent_orders->num_rows > 0): ?>
                                <div class="space-y-4">
                                    <?php while($order = $recent_orders->fetch_assoc()): ?>
                                        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition duration-300">
                                            <div class="flex items-center">
                                                <div class="w-12 h-12 bg-gradient-to-r from-purple-400 to-pink-500 rounded-lg flex items-center justify-center text-white mr-4">
                                                    <i class="fas fa-box"></i>
                                                </div>
                                                <div>
                                                    <p class="font-medium text-gray-800"><?php echo substr($order['product_name'], 0, 30); ?>...</p>
                                                    <p class="text-sm text-gray-500">
                                                        ৳<?php echo number_format($order['amount'], 2); ?> • 
                                                        <?php echo date('M d, Y', strtotime($order['created_at'])); ?>
                                                    </p>
                                                </div>
                                            </div>
                                            <div>
                                                <span class="inline-block px-3 py-1 text-sm rounded-full 
                                                    <?php echo $order['status'] == 'completed' ? 'bg-green-100 text-green-800' : 
                                                           ($order['status'] == 'processing' ? 'bg-blue-100 text-blue-800' : 
                                                           ($order['status'] == 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800')); ?>">
                                                    <?php echo ucfirst($order['status']); ?>
                                                </span>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-8">
                                    <i class="fas fa-shopping-bag text-gray-300 text-5xl mb-4"></i>
                                    <p class="text-gray-500">No orders yet</p>
                                    <a href="products.php" class="inline-block mt-4 text-blue-600 hover:text-blue-800 font-medium">
                                        <i class="fas fa-shopping-cart mr-1"></i> Browse Products
                                    </a>
                                </div>
                            <?php endif; ?>
                            
                            <div class="mt-6 text-center">
                                <a href="my-orders.php" class="text-purple-600 hover:text-purple-800 font-medium">
                                    <i class="fas fa-eye mr-1"></i> View All Orders
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Quick Actions -->
                <div class="mt-8 bg-white rounded-xl shadow-lg p-6 animate__animated animate__fadeInUp">
                    <h3 class="text-xl font-bold text-gray-800 mb-6">
                        <i class="fas fa-bolt mr-2"></i> Quick Actions
                    </h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <a href="deposit.php" class="bg-gradient-to-r from-green-50 to-emerald-50 p-4 rounded-xl text-center hover:from-green-100 hover:to-emerald-100 transition duration-300 transform hover:scale-105">
                            <div class="w-12 h-12 bg-gradient-to-r from-green-400 to-emerald-500 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-plus text-white text-xl"></i>
                            </div>
                            <p class="font-medium text-gray-800">Deposit</p>
                            <p class="text-sm text-gray-500">Add funds</p>
                        </a>
                        
                        <a href="products.php" class="bg-gradient-to-r from-blue-50 to-indigo-50 p-4 rounded-xl text-center hover:from-blue-100 hover:to-indigo-100 transition duration-300 transform hover:scale-105">
                            <div class="w-12 h-12 bg-gradient-to-r from-blue-400 to-indigo-500 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-shopping-cart text-white text-xl"></i>
                            </div>
                            <p class="font-medium text-gray-800">Products</p>
                            <p class="text-sm text-gray-500">Browse items</p>
                        </a>
                        
                        <a href="referrals.php" class="bg-gradient-to-r from-purple-50 to-pink-50 p-4 rounded-xl text-center hover:from-purple-100 hover:to-pink-100 transition duration-300 transform hover:scale-105">
                            <div class="w-12 h-12 bg-gradient-to-r from-purple-400 to-pink-500 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-users text-white text-xl"></i>
                            </div>
                            <p class="font-medium text-gray-800">Referrals</p>
                            <p class="text-sm text-gray-500">Earn money</p>
                        </a>
                        
                        <a href="profile.php" class="bg-gradient-to-r from-yellow-50 to-orange-50 p-4 rounded-xl text-center hover:from-yellow-100 hover:to-orange-100 transition duration-300 transform hover:scale-105">
                            <div class="w-12 h-12 bg-gradient-to-r from-yellow-400 to-orange-500 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-user text-white text-xl"></i>
                            </div>
                            <p class="font-medium text-gray-800">Profile</p>
                            <p class="text-sm text-gray-500">Edit details</p>
                        </a>
                    </div>
                </div>
            </main>
        </div>
    </div>
    
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('mobileSidebar');
            if(sidebar.style.display === 'none' || sidebar.style.display === '') {
                sidebar.style.display = 'block';
                setTimeout(() => {
                    sidebar.querySelector('.fixed.inset-y-0').classList.remove('translate-x-full');
                }, 10);
            } else {
                sidebar.querySelector('.fixed.inset-y-0').classList.add('translate-x-full');
                setTimeout(() => {
                    sidebar.style.display = 'none';
                }, 300);
            }
        }
        
        // Add animations on scroll
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.stat-card');
            cards.forEach((card, index) => {
                setTimeout(() => {
                    card.classList.add('animate__animated', 'animate__fadeInUp');
                }, index * 100);
            });
        });
    </script>
</body>
</html>